package edu.uky.ai.ml.nn;

/**
 * A special subclass of {@link Layer} representing the input layer.
 * 
 * @author Stephen G. Ware
 */
public class InputLayer extends Layer {

	/** The input neurons in this layer */
	public final InputNeuron[] neurons;
	
	/**
	 * Constructs a new input layer.
	 * 
	 * @param network the neural network to which this layer belongs
	 * @param neurons the number of neurons to create in this layer
	 */
	InputLayer(NeuralNetwork network, int neurons) {
		super(network, null, neurons, null);
		this.neurons = new InputNeuron[neurons];
		for(int i=0; i<neurons; i++)
			this.neurons[i] = (InputNeuron) ((Layer) this).neurons[i];
	}
}
